#ifndef __FLT2DPARAM_H
#define __FLT2DPARAM_H

/**
 *******************************************************************************
 *
 * @file flt2DParam.h
 *
 * \class CFlt2DParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a S2D<float> variable.
 *
 * The class implements a parameter interface for a S2D<float> variable.
 *
 *******************************************************************************/


/* INCLUDES */
#include "parameter.h"
#include "standardTypes.h"

namespace VIC
{
    /* PROTOTYPES */

    class CFlt2DParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CFlt2DParameter (  std::string               f_name_str = "",
                           std::string               f_comment_str = "",
                           S2D<float>                f_val = S2D<float>(0.f,0.f),
                           std::string               f_name1_str = "",
                           std::string               f_name2_str = "",
                           CParameterBaseConnector * f_connector_p = NULL );

        virtual ~CFlt2DParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set Flt2D value
        virtual S2D<float>      getValue ( ) const;
        virtual bool            setValue ( S2D<float> f_value,
                                           bool       f_shouldUpdate_b = true );
        
        const std::string *     getNames ( ) const 
        {
            return m_names_p;
        }

        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        S2D<float>  m_value;

        /// Stored value.
        std::string  m_names_p[2];
    };
}


#endif // __FLT2DPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: flt2DParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
