#ifndef __FLOATPARAMEDITOR_H
#define __FLOATPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file floatParamEditor.h
 *
 * \class CFloatParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CFloatParameter.
 *
 * The class implements a simple Qt editor with an input box where
 * the user enters a float value.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "floatParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CDoubleEditor;
    
    class CFloatParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CFloatParameterEditor ( CFloatParameter *  f_parameter_p,
                                 QWidget *         f_parent_p = NULL );

        virtual ~CFloatParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

    /// Protected static members
    protected:
        const static unsigned int m_maxDecimals_cui;

    /// Protected members
    protected:

        /// Stored value.
        CDoubleEditor *          m_qdsb_p;

        /// Associated Float parameter
        CFloatParameter *        m_parameter_p;
    };
}

#endif // __FLOATPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: floatParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
