#ifndef __FLOATPARAM_H
#define __FLOATPARAM_H

/**
 *******************************************************************************
 *
 * @file floatParam.h
 *
 * \class CFloatParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a float variable.
 *
 * The class implements a parameter interface for a float variable.
 *
 *******************************************************************************/

/* INCLUDES */
#include "parameter.h"

namespace VIC
{

    class CFloatParameter : public CParameter
    {
    /// Constructors/Destructor
    public:
        
        /// Constructors/Destructor
        CFloatParameter (  std::string               f_name_str = "",
                           std::string               f_comment_str = "",
                           float                     f_value_f = 0.0f,
                           CParameterBaseConnector * f_connector_p = NULL );

        virtual ~CFloatParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set bool value
        virtual float           getValue ( ) const;
        virtual bool            setValue ( float  f_value_b,
                                           bool   f_shouldUpdate_b = true );
        

        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        float                  m_value_f;
    };
}


#endif // __FLOATPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: floatParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
