#ifndef __FLOATIMAGE_H
#define __FLOATIMAGE_H

/**
 *******************************************************************************
 *
 * @file floatImage.h
 *
 * \class CFloatImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <float>.
 *
 * The class is a type definition of CTypedImage<float>.
 *
 ******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<float>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(float) );
        setDataType( IDT_FLOAT );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<float> CFloatImage;
}



#endif // __FLOATIMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: floatImage.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
