#ifndef __FILEPATHPARAMEDITOR_H
#define __FILEPATHPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file filePathParamEditor.h
 *
 * \class CFilePathParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CStringParameter containing
 * the path to a file.
 *
 * The class implements a simple Qt editor with an input boxes (where the user
 * the user enters a file path) and a button with which the user can open a 
 * dialog for selecting a file.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "filePathParam.h"

/* PROTOTYPES */
class QLineEdit;
class QPushButton;

namespace VIC
{
    /* PROTOTYPES */

    class CFilePathParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT

    public:
        typedef enum
        {
            FT_FILE,
            FT_DIRECTORY
        } EFileType_t;
        
    public:
        
        /// Constructors/Destructor
        CFilePathParameterEditor ( CStringParameter *    f_parameter_p,
                                   EFileType_t           f_fileType_e,
                                   QWidget *             f_parent_p = NULL );

        virtual ~CFilePathParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();
        void openDialogBox();
        

    /// Protected members
    protected:

        /// Stored value.
        EFileType_t               m_fileType_e;

        /// Stored value.
        QLineEdit *               m_qle_p;

        /// Buttom to open file dialog.
        QPushButton *             m_qpb_p;

        /// Associated FilePath parameter
        CStringParameter *        m_parameter_p;
    };
}

#endif // __FILEPATHPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: filePathParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
