#ifndef __FILEPATHPARAM_H
#define __FILEPATHPARAM_H

/**
 *******************************************************************************
 *
 * @file filePathParam.h
 *
 * \class CFilePathParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a std::string variable.
 *
 * The class implements a parameter interface for a std::string variable.
 *
 *******************************************************************************/

/* INCLUDES */
#include "stringParam.h"

namespace VIC
{
    /* PROTOTYPES */

    class CFilePathParameter : public CStringParameter
    {
    /// Constructors/Destructor
    public:
        /// Constructors/Destructor
        CFilePathParameter (  std::string               f_name_str = "",
                              std::string               f_comment_str = "",
                              std::string               f_value_str = false,
                              CParameterBaseConnector * f_connector_p = NULL );
        
    public:
        
        /// Get editor.
        virtual QWidget *       createEditor ( );
        
        /// Protected members
    protected:
        
    };
}


#endif // __STRINGPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: filePathParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
