#ifndef __EVENTS_H
#define __EVENTS_H

/**
 *******************************************************************************
 *
 * @file events.h
 *
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Definition of event data structs.
 *
 * The events or signals are generated in the CDisplay class and provided to
 * the operators via the CMainWindow class.
 *
 *******************************************************************************/

/* INCLUDES */
#include <QMouseEvent>
#include <QRegion>
#include <QKeyEvent>
#include <QWheelEvent>

#include "standardTypes.h"

/* CONSTANTS */

/* TYPE DEFINITION */
namespace VIC
{
    typedef struct 
    {
        QMouseEvent * mouseEvent;
        QRegion       region;
    } CRegionSelectedEvent;
    
    typedef struct
    {
        QMouseEvent *qtMouseEvent_p;
        S2D<float>   posInDisplay;
        S2D<int>     displayScreen;
        S2D<float>   posInScreen;
    } CMouseEvent;

    //typedef QMouseEvent CMouseEvent;
    typedef struct
    {
        QKeyEvent   *qtKeyEvent_p;
    } CKeyEvent;

    typedef QWheelEvent CWheelEvent;

}


#endif // __EVENTS_H

/* ////////////  Version History ///////////////
 *  $Log: events.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
