#ifndef __ENUMPARAMEDITOR_H
#define __ENUMPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file enumParamEditor.h
 *
 * \class CEnumParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CEnumParameter
 *
 * The class implements a simple Qt editor with a combo box where the user
 * can select one of the multiple enumeration options.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "enumParamBase.h"

/* PROTOTYPES */
class QComboBox;

namespace VIC
{
    /* PROTOTYPES */

    class CEnumParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CEnumParameterEditor ( CEnumParameterBase *  f_parameter_p,
                               QWidget *             f_parent_p = NULL );

        virtual ~CEnumParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

    /// Protected static members
    protected:

    /// Protected members
    protected:

        /// Stored value.
        QComboBox *           m_qcb_p;

        /// Associated Enum parameter
        CEnumParameterBase *  m_parameter_p;
    };
}

#endif // __ENUMPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: enumParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
