#ifndef __ENUMPARAMBASE_H
#define __ENUMPARAMBASE_H

/**
 *******************************************************************************
 *
 * @file enumParamBase.h
 *
 * \class CEnumParameterBase
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Base class for a parameter interface for a enum variable.
 *
 * The class implements a parameter interface for an enum variable.
 *
 *******************************************************************************/

/* INCLUDES */

/* INCLUDES */
#include "parameter.h"
#include <map>

namespace VIC
{
    class CEnumParameterBase : public CParameter
    {
        friend class CEnumParameterEditor;
    /// Constructors/Destructor
    public:
        
        /// Constructors/Destructor
        CEnumParameterBase (  std::string               f_name_str    = "",
                              std::string               f_comment_str = "",
                              CParameterBaseConnector * f_connector_p = NULL );
                  

        virtual ~CEnumParameterBase ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
                
        virtual bool            setValueFromString ( std::string f_val_str );        
 
        /// Get editor.
        virtual QWidget *       createEditor ( );


    /// Protected members.
    protected:
        
        /// Get number of descriptions.
        virtual int             getCount ( ) const = 0;

        /// Get description/value pair.
        virtual bool            getPair ( unsigned int  f_index_i,
                                          int         & fr_value_i,
                                          std::string & fr_descr_str ) = 0;

        /// Get and set int value
        /// Getting undefined reference if defining this funciton as virtual pure so
        /// an implementation was added.
        virtual int             getIntValue ( ) const {return 0;}; 
        

        virtual bool            setValueFromInt ( unsigned int f_newVal_i ) = 0;

        /// Set value from order in the map list.
        virtual bool            setValueFromIdx ( unsigned int f_idx_ui ) = 0;

    /// Protected members.
    protected:

    /// Protected members
    protected:
    };
}

#endif // __ENUMPARAMBASE_H

/* ////////////  Version History ///////////////
 *  $Log: enumParamBase.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
