#ifndef __ENUMPARAM_H
#define __ENUMPARAM_H

/**
 *******************************************************************************
 *
 * @file enumParam.h
 *
 * \class CEnumParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Templated class for a parameter interface for a enum variable.
 *
 * The template type must be that of the desired enum type.
 *
 *******************************************************************************/

/* INCLUDES */
#include "enumParamBase.h"

namespace VIC
{
    template < class _EnumType >
    class CEnumParameter : public CEnumParameterBase
    {
    /// Constructors/Destructor
    public:
        
        /// Constructors/Destructor
        CEnumParameter (  std::string               f_name_str    = "",
                          std::string               f_comment_str = "",
                          _EnumType                 f_value_e     = (_EnumType) 0,
                          std::string               f_descr_srt   = "No description",
                          CParameterBaseConnector * f_connector_p = NULL );

        virtual ~CEnumParameter ();

    /// Derived from parent
    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str ); 

        /// Get editor.
        virtual QWidget *       createEditor ( );

    public:
        /// Get and set bool value
        virtual _EnumType       getValue ( );
        virtual bool            setValue ( _EnumType f_newVal_i,
                                           bool      f_shouldUpdate_b = true );

        /// Add description of a value.
        virtual void            addDescription ( _EnumType   f_value_e,
                                                 std::string f_descr_srt );

        
    /// Protected members derived from parent.
    protected:
        
        /// Get number of descriptions.
        virtual int             getCount ( ) const;

        /// Get description/value pair.
        virtual bool            getPair ( unsigned int  f_index_i,
                                          int         & fr_value_i,
                                          std::string & fr_descr_str );

        /// Get and set int value
        virtual int             getIntValue ( ) const;

        virtual bool            setValueFromInt ( unsigned int f_newVal_i );

        /// Set value from order in the map list.
        virtual bool            setValueFromIdx ( unsigned int f_idx_ui );

    /// Protected members
    protected:
        /// Value.
        _EnumType                      m_value_e;

        /// Stored value.
        std::map<int, std::string>     m_map;
    };
}

#include "enumParam_inline.h"

#endif // __ENUMPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: enumParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
