#ifndef __CVGLDRAWINGLIST_H
#define __CVGLDRAWINGLIST_H

/**
 *******************************************************************************
 *
 * @file drawingListPreview.h
 *
 * \class CDrawingListPreview
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief This class implements a preview of the content of a drawing list.
 *
 * This class implements a preview of the content of a drawing list to be used
 * as a tooltip display in the CDisplayTreeDlg class.
 *
 *******************************************************************************/

/* INCLUDES */
#include <QGLWidget>
#include "events.h"
#include "drawingList.h"

namespace VIC
{

    /* PROTOTYPES */
    class CDisplayNode;

    class CDrawingListPreview : public QGLWidget
    {
        Q_OBJECT

        public:
        CDrawingListPreview( QWidget   *  parent = 0,
                             QGLWidget *  f_sharedGLWidget_p = 0 );

        ~CDrawingListPreview();

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

    /// Inherited slots.
    public:
        virtual void hide ();
        virtual void show ();
        

    /// Set node to preview
    public:

        /// Set node to preview.
        void setNode       ( CDisplayNode * f_node_p ) { m_previewNode_p = f_node_p; }

        /// Set screen size.
        void setScreenSize ( S2D<int> f_size ) { m_screenSize = f_size; }

    /// Inherited members.
    protected:
        
        virtual void mouseMoveEvent ( QMouseEvent *  f_event_p );
        virtual void initializeGL();
        virtual void paintGL();
        virtual void resizeGL ( int width, int height );

    /// Own help methods.
    protected:

    /// Data members.
    private:

        /// Root node of display lists tree.
        CDisplayNode *             m_previewNode_p;

        /// Size of each screen.
        S2D<int>                   m_screenSize;

        /// Timer for showing the preview.
        QTimer *                   m_showTimer_p;

        /// Associated widget.
        QWidget *                  m_associatedWidget_p;
    };
}


#endif // #define __CVGLDRAWINGLIST_H

/* ////////////  Version History ///////////////
 *  $Log: drawingListPreview.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
