#ifndef __DRAWINGLISTHANDLER_H
#define __DRAWINGLISTHANDLER_H

/**
 *******************************************************************************
 *
 * @file drawingListHandler.h
 *
 * \class CDrawingListHandler
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief This class implements a handler for drawing list.
 *
 * The handler itself is instantiated as a static member in the COperator class.
 * It handles drawing lists, searching existing drawing list or creating them if
 * the requested drawing list does not exist.
 *
 *******************************************************************************/

/* INCLUDES */
#include <string>
#include <map>

/* CONSTANTS */

namespace VIC
{
 /* CONSTANTS */


/* DATA TYPES */


/* PROTOTYPES */

    class COperator;
    class CDrawingList;
    class CDisplayOpNode;
    
    class CDrawingListHandler
    {
    /// Public data types.
    public:


    /// Construction, Destruction
    public:        
        CDrawingListHandler();
        virtual ~CDrawingListHandler();

    /// Get and sets.
    public:
        /// Get pointer to drawing list.
        CDrawingList *    getDrawingList ( std::string f_name_str, 
                                           COperator * f_op_p );

        /// Get root node.
        CDisplayOpNode  * getRootNode ( ) const;

        /// Set drawing-list-changed flag.
        void              setDisplayUpdateFlag ( bool f_val_b );

        /// Get drawing-list-changed flag.
        bool              mustUpdateDisplay ( ) const;

    private:

        /// Root node.
        CDisplayOpNode *          m_root_p;

        /// Flag for indicating a change in some drawing list.
        bool                      m_drawingListChanged_b;
    };    


    inline CDisplayOpNode  * 
    CDrawingListHandler::getRootNode ( ) const 
    { 
        return m_root_p; 
    }

    inline void 
    CDrawingListHandler::setDisplayUpdateFlag ( bool f_val_b )
    {
        m_drawingListChanged_b = f_val_b;
    }

    inline bool
    CDrawingListHandler::mustUpdateDisplay ( ) const
    {
        return m_drawingListChanged_b;
    }
}

#endif // __DRAWINGLISTHANDLER_H

/* ////////////  Version History ///////////////
 *  $Log: drawingListHandler.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
