#ifndef __DRAWINGELEMENT_H
#define __DRAWINGELEMENT_H

/**
 *******************************************************************************
 *
 * @file drawingElementList.h
 *
 * \class CDrawingElementList
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief This abstract class provides the base for primitives drawing lists.
 *
 * Concrete child classes must implement the methods clear(), isBlendable(), 
 * show() and getSize().
 *
 *******************************************************************************/

/* INCLUDES */

#include "logger.h"

#include <string>

/* CONSTANTS */

namespace VIC
{
    class CDrawingElementList
    {
    public:
        
        CDrawingElementList() {}
        virtual ~CDrawingElementList() {}
        
        /******************************************************
         * methods
         ******************************************************/
        
        // Clear all elements.
        virtual bool clear() = 0;
        
        // Inform if this drawing list is blendable.
        virtual bool isBlendable() = 0;
        
        // Draw all elements.
        virtual bool show() const = 0;
        
        // Number of elements.
        virtual int  getSize() const = 0;
        
        // Write elements in a SVG file.
        virtual bool write ( FILE*                f_file_p,
                             const float          f_offsetX_f = 0.0,
                             const float          f_offsetY_f = 0.0,
                             const std::string    f_parameters_str = "") const;

    private:
        
    };

    inline
    bool CDrawingElementList::write ( FILE*                /* f_file_p */,
                                      const float          /* f_offsetX_f = 0.0 */,
                                      const float          /* f_offsetY_f = 0.0 */,
                                      const std::string    /* f_parameters_str = "" */ ) const
    {
        logger::warn("write(...) not implemented for this class.");
        return false;
    }
    
    

} // Namespace VIC


#endif // __DRAWINGELEMENT_H

/* ////////////  Version History ///////////////
 *  $Log: drawingElementList.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
