#ifndef __DOUBLEPARAMEDITOR_H
#define __DOUBLEPARAMEDITOR_H

/**
 *******************************************************************************
 *
 * @file doubleParamEditor.h
 *
 * \class CDoubleParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CDoubleParameter.
 *
 * The class implements a simple Qt editor with an input box where
 * the user enters a double value.
 *
 *******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "doubleParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CDoubleEditor;
    
    class CDoubleParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CDoubleParameterEditor ( CDoubleParameter *  f_parameter_p,
                                 QWidget *           f_parent_p = NULL );

        virtual ~CDoubleParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

    /// Protected static members
    protected:
        const static unsigned int m_maxDecimals_cui;

        /// Protected members
    protected:

        /// Stored value.
        CDoubleEditor *           m_qdsb_p;

        /// Associated Double parameter
        CDoubleParameter *        m_parameter_p;
    };
}

#endif // __DOUBLEPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: doubleParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
