#ifndef __DOUBLEPARAM_H
#define __DOUBLEPARAM_H

/**
 *******************************************************************************
 *
 * @file doubleParam.h
 *
 * \class CDoubleParameter
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Parameter interface for a double variable.
 *
 * The class implements a parameter interface for a double variable.
 *
 *******************************************************************************/


/* INCLUDES */
#include "parameter.h"

namespace VIC
{

    class CDoubleParameter : public CParameter
    {
        /// Constructors/Destructor
    public:
        
        /// Constructors/Destructor
        CDoubleParameter (   std::string               f_name_str = "", 
                             std::string               f_comment_str = "",
                             double                    f_value_d = 0.0,
                             CParameterBaseConnector * f_connector_p = NULL );

        virtual ~CDoubleParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set bool value
        virtual double          getValue ( ) const;
        virtual bool            setValue ( double f_value_b,
                                           bool   f_shouldUpdate_b = true );


        /// Get editor.
        virtual QWidget *       createEditor ( );

        /// Protected members
    protected:

        /// Stored value.
        double                  m_value_d;
    };
}


#endif // __BOOLPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: doubleParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
