#ifndef __DOUBLEIMAGE_H
#define __DOUBLEIMAGE_H

/**
 *******************************************************************************
 *
 * @file doubleImage.h
 *
 * \class CDoubleImage
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Template class CTypedImage instantiated with <double>.
 *
 * The class is a type definition of CTypedImage<double>.
 *
 ******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<double>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(double) );
        setDataType( IDT_DOUBLE );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<double> CDoubleImage;
}



#endif // __DOUBLEIMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: doubleImage.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
