#ifndef __DOUBLEEDITOR_H
#define __DOUBLEEDITOR_H

/**
 *******************************************************************************
 *
 * @file doubleEditor.h
 *
 * \class CDoubleEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CDoubleParameter.
 *
 * The class implements a simple Qt editor with one input box where
 * the user enters a double value.
 *
 ******************************************************************************/

/* INCLUDES */
#include <QWidget>

/* PROTOTYPES */
class QLineEdit;

namespace VIC
{
    /* PROTOTYPES */

    class CDoubleEditor : public QWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CDoubleEditor ( double     f_value_d,
                        QWidget *  f_parent_p = NULL );

        virtual ~CDoubleEditor ();

        double getValue() const 
        { return m_value_d; }

        bool   setValue( double f_value_d );
                         
        unsigned int getDecimals() const 
        { return m_maxDecimals_ui; }

        void         setDecimals( unsigned int f_maxDec_ui ) 
        { m_maxDecimals_ui = f_maxDec_ui; }
        
        virtual QSize sizeHint () const;

    protected slots:
        void lineEditChanged();

    signals:
        void valueChanged( double );
        
        /// Protected members
    protected:

        /// Stored value.
        QLineEdit *          m_qle_p;

        /// Double value
        double               m_value_d;

        /// Double value
        unsigned int         m_maxDecimals_ui;
    };
}

#endif // __DOUBLEEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: doubleEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
