#ifndef __DISPLAYWIDGET_H
#define __DISPLAYWIDGET_H

#include <QDialog>

#include "display.h"

class QSpinBox;
class QSplitter;
class QFrame;
class QPushButton;
class QLabel;

namespace VIC
{
/* NAMESPACE PROTOTYPES */
    class CDrawingListHandler;
    class CDisplayTreeDlg;
    class CDisplayOpNode;
    
/* CLASS DEFINITION */
    class CDisplayWidget : public QWidget
    {
        Q_OBJECT
        
    public:
        CDisplayWidget( QWidget *              f_parent_p,
                        CDrawingListHandler *  f_handler_p );
                        

        QWidget  * getDialog()  const;
        CDisplay * getDisplay() const;

    public slots:
        /// Force update of display and status bars.
        virtual void update ( );

        /// Conditional update of display and status bars.
        virtual void update ( int f_forceUpdate_b );

        /// Switch full screen mode.
        virtual void switchFullScreen ( );
 
        /// Exit full screen mode.
        virtual void exitFullScreen ( );

        /// Force update of display and status bars.
        virtual void keyPressed ( CKeyEvent * f_keyEvent_p );        

        /// Mouse move event.
        virtual void mouseMoved ( CMouseEvent *  f_event_p );

    signals:
            
    private slots:

    private:
        bool isInFSMode() const;

        void createForm(); 

    private:

        /// Drawing list handler.
        CDrawingListHandler *  m_drawingListHandler_p;

        /// Display Tree Dialog.
        CDisplayTreeDlg *      m_treeDlg_p;

        /// GL Display
        CDisplay *             m_glDisplay_p;

        /// Is grabbing?
        bool                   m_grabbing_b;

        /// Top controls frame
        QFrame *               m_qfTopControls_p;
        
        /// Action 1
        QPushButton *          m_qpbAction1_p;

        /// Action 1
        QPushButton *          m_qpbAction2_p;

        /// Action 1
        QPushButton *          m_qpbAction3_p;

        /// Frame containing qspin boxes.
        QFrame *               m_qfNumScreens_p;

        /// Label "X"
        QLabel *               m_qlabel1_p;

        /// Spin box for horizontal screens.
        QSpinBox *             m_qsbNumHorScreens_p;

        /// Spin box for vertical screens.
        QSpinBox *             m_qsbNumVertScreens_p;

        /// QFrame for the status bar.
        QFrame *               m_qfStatusBar_p;

        /// Splitter of user and systems messages.
        QSplitter *            m_qStatusBarSplitter_p;

        /// User message label.
        QLabel *               m_qlUserMessage_p;

        /// System message label.
        QLabel *               m_qlSystemMessage_p;
    };

    inline bool 
    CDisplayWidget::isInFSMode() const
    {
        return !m_glDisplay_p -> parent();
    }
}


#endif // __DISPLAYWIDGET_H

/* ////////////  Version History ///////////////
 *  $Log: displayWidget.h,v $
 *  Revision 1.3  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
