#ifndef __DISPLAYTREEVIEW_H
#define __DISPLAYTREEVIEW_H

/*@@@**************************************************************************
 ** \file  displayTreeView
 * \date   Tue May 19 16:51:31 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <QTreeView>

/* CONSTANTS */

/* PROTOTYPES */

class QGLWidget;
class QTimer;

namespace VIC
{
    class CDrawingListPreview;

    class CDisplayTreeView : public QTreeView
    {
        Q_OBJECT
        
        public:
        CDisplayTreeView ( QWidget *    f_parent_p = 0,
                           QGLWidget *  f_sharedGLWidget_p = 0 );
        
        virtual ~CDisplayTreeView ();

        void     saveParameters();
        void     loadParameters();

    /// Public slots.
    public slots:
        
        void showPreview();
        
    /// Inherited virtual methods
    protected:
        virtual void dragEnterEvent (QDragEnterEvent * f_event_p);
        virtual void dragMoveEvent  (QDragMoveEvent * f_event_p);
        virtual void dropEvent      (QDropEvent * f_event_p);
        virtual void startDrag      (Qt::DropActions supportedActions_e );

        virtual void mouseMoveEvent ( QMouseEvent * f_event_p );
        virtual void leaveEvent ( QEvent * f_event_p );

        virtual void dataChanged ( const QModelIndex & f_topLeft, 
                                   const QModelIndex & f_bottomRight ) ;

    /// Help methods.
    protected:
        
    /// Members
    protected:

        /// Timer for detecting that the mouse do not move 
        /// during the time interval in order to show the preview
        /// as a tool tip.
        QTimer *                m_previewTimer_p;

        /// Preview widget.
        CDrawingListPreview *   m_previewWidget_p;

        /// Index under mouse.
        QGLWidget *             m_sharedGLWidget_p;

        /// Preview widget.
        QPoint                  m_lastMousePos;

        /// Start drag position.
        QPoint                  m_dragStartPosition;

        /// Index under mouse.
        QModelIndex             m_index;
    };
}


#endif // __DISPLAYTREEVIEW_H

/* ////////////  Version History ///////////////
 *  $Log: displayTreeView.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
