#ifndef __DISPLAYTREEITEMMODEL_H
#define __DISPLAYTREEITEMMODEL_H

/*@@@**************************************************************************
 ** \file  displayTreeItemModel
 * \date   Tue Apr 14 17:05:05 GMT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */

#include <QAbstractItemModel>
#include <QModelIndex>
#include <QVariant>

/* CONSTANTS */


namespace VIC
{

/* PROTOTYPES */
    class CDisplayOpNode;

    class CDisplayTreeItemModel: public  QAbstractItemModel
    {
        Q_OBJECT
        
        public:
        CDisplayTreeItemModel ( CDisplayOpNode *  f_rootNode_p,
                                QObject *         f_parent_p = 0 );

        ~CDisplayTreeItemModel ();
        
        QVariant      data ( const QModelIndex &f_index_i, 
                             int                f_role_i) const;
        Qt::ItemFlags flags ( const QModelIndex &f_index) const;
        
        QVariant      headerData ( int              f_section_i, 
                                   Qt::Orientation  f_orientation_e,
                                   int              f_role_i = Qt::DisplayRole) const;
        
        QModelIndex   index ( int f_row_i, 
                              int f_column_i,
                              const QModelIndex &f_parent = QModelIndex()) const;
        
        QModelIndex   parent ( const QModelIndex &f_index_i) const;
        
        int           rowCount    ( const QModelIndex 
                                    &f_parent = QModelIndex() ) const;
        
        int           columnCount ( const QModelIndex 
                                    &f_parent = QModelIndex() ) const;
        
        bool          setData ( const QModelIndex &f_index, 
                                const QVariant    &f_value, 
                                int                f_role_i );
 
    protected:

    private:
        
        CDisplayOpNode *          m_rootNode_p;
    };
}


#endif // __DISPLAYTREEITEMMODEL_H

/* ////////////  Version History ///////////////
 *  $Log: displayTreeItemModel.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
