#ifndef __DISPLAYSTATEPARAM_H
#define __DISPLAYSTATEPARAM_H

/*@@@**************************************************************************
 ** \file  displayStateParam
 * \date   Mon Apr 27 13:51:09 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "parameter.h"
#include "standardTypes.h"

namespace VIC
{
    /* PROTOTYPES */

    class CDisplayStateParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CDisplayStateParameter (  std::string               f_name_str = "",
                                  std::string               f_comment_str = "",
                                  SDisplayState             f_displayState = SDisplayState(S2D<int>(0,0), false),
                                  CParameterBaseConnector * f_connector_p = NULL );
        
        virtual ~CDisplayStateParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set displayState value
        virtual SDisplayState getValue ( ) const;
        virtual bool          setValue ( SDisplayState f_displayState,
                                         bool          f_shouldUpdate_b = true );
        
        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        SDisplayState  m_displayState;
    };
}


#endif // __DISPLAYSTATEPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: displayStateParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
