#ifndef __DISPLAYCOLORENCIMAGELIST_H
#define __DISPLAYCOLORENCIMAGELIST_H

/**
 * @file displayCEImageList.h
 *
 * \class CDisplayCEImageList
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Handles a list of images for displaying in screen or writing in file
 * with a given color encoding.
 *
 * The class is derived from CDrawingElementList implementing a list of images.
 * Images are composed of: 
 *  - the image itself
 *  - row and column of top-left corner where to display it,
 *  - display width and height,
 *  - the color encoding object (of type CColorEncoding).
 *
 */

/* INCLUDES */
#include "drawingElementList.h"
#include "colors.h"
#include "colorEncoding.h"

#include "image.h"

#include <vector>

namespace VIC
{
    class CDisplayColorEncImageList: public CDrawingElementList
    {
    /// Constructor, Destructor
    public:
        /// Constructor
        CDisplayColorEncImageList();

        /// Destructor.
        virtual ~CDisplayColorEncImageList();

    /// Operations.
    public:
        // Add images from other list.
        virtual bool add (  const CDisplayColorEncImageList & f_otherList );

        // Add an image.
        virtual bool add (  const CImageBase *  f_image_p,
                            float               f_u_f, 
                            float               f_v_f,
                            float               f_dispWidth_f,
                            float               f_dispHeight_f,
                            CColorEncoding      f_encoder_f,
                            float               f_alpha_f = 1.f,
                            bool                f_makeCopy_b = false );

        // Is blendable.
        virtual bool isBlendable () { return false; }

        // Clear all lines.
        virtual bool clear ();

        // Draw all lines.
        virtual bool show () const;

        // Write line in a SVG file.
        virtual bool write ( FILE*              f_file_p,
                             const float        f_offsetU_f = 0.0,
                             const float        f_offsetV_f = 0.0,
                             const std::string  f_parameters_str = "") const;

        // Return number of elements.
        virtual int  getSize () const;

    protected:
        struct SDisplayColorEncImage
        {
            /// Color information
            const CImageBase *  image_p;

            /// Copied
            bool                copied_b;
            
            /// Start position.
            float               u_f, v_f;

            /// Width and height.
            float               width_f, height_f;

            /// Alpha value.
            float               alpha_f;

            /// Color encoding
            CColorEncoding      encoder;

            void freeImage()
            {
                if ( copied_b )
                    delete image_p;
            }
            
        };

    /// Private Methods
    private:
        template <class Type_>
        bool showWithType ( const SDisplayColorEncImage & f_elem ) const;
        
    /// Private Members
    private:
        
        typedef std::vector<SDisplayColorEncImage>  DisplayColorEncImageList_t;
        
        /// Vector of images.
        DisplayColorEncImageList_t     m_image_v;        
    };
} // Namespace VIC


#endif // __DISPLAYCOLORENCIMAGELIST_H

/* ////////////  Version History ///////////////
 *  $Log: displayCEImageList.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
