#ifndef __CVGLDISPLAY_H
#define __CVGLDISPLAY_H

/*@@@**************************************************************************
 * \file  drawingList
 * \date   Wed Feb 25 16:24:42 Local time zone must be set--see zic manual page 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include <QGLWidget>
#include "events.h"
#include "drawingList.h"

namespace VIC
{

    /* PROTOTYPES */
    class CDisplayOpNode;

    class CDisplay : public QGLWidget
    {
        Q_OBJECT

        public:
        CDisplay( CDisplayOpNode * const  f_rootNode_p,
                  QWidget *               parent = 0 );

        ~CDisplay();

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

    /// Zoom methods.
    public:
        
        bool   setZoomOnScreen ( const S2D<float> screen,
                                 const bool       f_update_b = true );
        
        bool   setZoomOnScreen ( const unsigned int f_screenX_ui, 
                                 const unsigned int f_screenY_ui,
                                 const bool         f_update_b = true );
        
        QImage renderGL ();
        
   signals:
        void clicked();
        void fullScreenSwitched();
        void exitFullScreen();

        void keyPressed    ( CKeyEvent   *  f_event_p );
        void mousePressed  ( CMouseEvent *  f_event_p );
        void mouseReleased ( CMouseEvent *  f_event_p );
        void mouseMoved    ( CMouseEvent *  f_event_p );
        void wheelTurned   ( CWheelEvent *  f_event_p );

        void regionSelected  ( CRegionSelectedEvent * 
                                            f_event_p );
        
    /// Inherited members.
    protected:
        
        virtual void initializeGL();
        virtual void paintGL();
        virtual void resizeGL ( int width, 
                                int height );
        virtual void mousePressEvent   ( QMouseEvent *  f_event_p );
        virtual void mouseMoveEvent    ( QMouseEvent *  f_event_p );
        virtual void mouseReleaseEvent ( QMouseEvent *  f_event_p );
        virtual void wheelEvent        ( QWheelEvent *  f_event_p );
        virtual void keyPressEvent     ( QKeyEvent *    f_event_p );

        virtual void dragEnterEvent    ( QDragEnterEvent *f_event_p );
        virtual void dragMoveEvent     ( QDragMoveEvent *f_event_p );
        virtual void dropEvent         ( QDropEvent *f_event_p );

    /// Own help methods.
    protected:

        virtual void zoom ( float f_x_f, 
                            float f_y_f, 
                            float f_newZoomFactor_f,
                            bool f_updateGL_b );
        virtual void zoomIn();
        virtual void zoomOut();
        

        void displayScreens ( CDisplayOpNode * const f_parent_p );
        
        bool isOneScreenMode   ( ) const { return m_fsScreen.isValid(); }
        void exitOneScreenMode ( ) { m_fsScreen.invalidate();; }
        
        CMouseEvent* getMouseEventData( QMouseEvent * f_event_p );

    /// Data members.
    private:

        /// Root node of display lists tree.
        CDisplayOpNode *           m_rootNode_p;

        /// Size of each screen.
        S2D<int>                   m_screenSize;

        /// Screen count.
        S2D<unsigned int>          m_screenCount;
        
        /// Position of zoom.
        S2D<float>                 m_zoomTL;

        /// Position of zoom when mouse was pressed.
        S2D<float>                 m_prevZoomTL;

        /// Zoom factor.
        float                      m_zoomFactor_f;

        /// Position of mouse when mouse was pressed.
        S2D<float>                 m_prevMousePos;
        
        /// Scale of display.
        S2D<float>                 m_roiSize;

        /// Scale of display.
        S2D<float>                 m_roiPos;

        /// Curren screen being display in one screen mode.
        S2D<int>                   m_fsScreen;


    };
}


#endif // #define __CVGLDISPLAY_H

/* ////////////  Version History ///////////////
 *  $Log: display.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
