#ifndef __DBL2DPARAMEDITOR_H
#define __DBL2DPARAMEDITOR_H

/**
 * @file dblt2DParamEditor.h
 *
 * \class CDbl2DParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type CDbl2DParameter.
 *
 * The class implements a simple Qt editor with two input boxes where
 * the user enters double values.
 */

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "dbl2DParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CDoubleEditor;

    class CDbl2DParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CDbl2DParameterEditor ( CDbl2DParameter *  f_parameter_p,
                                QWidget *          f_parent_p = NULL );

        virtual ~CDbl2DParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

        /// Protected members
    protected:

        /// Stored value.
        CDoubleEditor *           m_qdsb_p[2];

        /// Associated Dbl2D parameter
        CDbl2DParameter *         m_parameter_p;

        /// Amount of decimals to consider.
        const static unsigned int m_maxDecimals_cui;
    };
}

#endif // __DBL2DPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: dbl2DParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
