#ifndef __DBL2DPARAM_H
#define __DBL2DPARAM_H

/*@@@**************************************************************************
 ** \file  Dbl2DParam
 * \date   Mon Apr 27 13:51:09 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "parameter.h"
#include "standardTypes.h"

namespace VIC
{
    /* PROTOTYPES */

    class CDbl2DParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CDbl2DParameter (  std::string               f_name_str = "",
                           std::string               f_comment_str = "",
                           S2D<double>               f_val = S2D<double>(0.,0.),
                           std::string               f_name1_str = "",
                           std::string               f_name2_str = "",
                           CParameterBaseConnector * f_connector_p = NULL );

        virtual ~CDbl2DParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set Dbl2D value
        virtual S2D<double>     getValue ( ) const;
        virtual bool            setValue ( S2D<double> f_value,
                                           bool        f_shouldUpdate_b = true );
        
        const std::string *     getNames ( ) const 
        {
            return m_names_p;
        }

        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        S2D<double>  m_value;

        /// Stored value.
        std::string  m_names_p[2];
    };
}


#endif // __DBL2DPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: dbl2DParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
