#ifndef __COLORPARAMEDITOR_H
#define __COLORPARAMEDITOR_H

/*@@@**************************************************************************
** \file  colorParamEditor
* \date   Mon Apr 27 14:47:12 EDT 2009
* \author Hernan Badino
* \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "colorParam.h"

/* PROTOTYPES */
class QSpinBox;
class QPushButton;


namespace VIC
{
    /* PROTOTYPES */

    class CColorParameterEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        CColorParameterEditor ( CColorParameter *  f_parameter_p,
                                QWidget *          f_parent_p = NULL );

        virtual ~CColorParameterEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

        /// Button was clicked.
        void openColorDialog();

        /// Protected members
    protected:

        /// Stored value.
        QSpinBox *               m_qsb_p[4];

        /// Buttom to open color dialog.
        QPushButton *            m_qpb_p;

        /// Associated Color parameter
        CColorParameter *        m_parameter_p;
    };
}

#endif // __COLORPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: colorParamEditor.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
