#ifndef __COLORPARAM_H
#define __COLORPARAM_H

/*@@@**************************************************************************
 ** \file  colorParam
 * \date   Mon Apr 27 13:51:09 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "parameter.h"
#include "colors.h"

namespace VIC
{
    /* PROTOTYPES */

    class CColorParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CColorParameter (  std::string               f_name_str = "",
                           std::string               f_comment_str = "",
                           SRgba                     f_color = CColor::black,
                           bool                      f_useAlpha_b = true,
                           CParameterBaseConnector * f_connector_p = NULL );
        
        virtual ~CColorParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set color value
        virtual SRgba           getValue ( );
        virtual bool            setValue ( SRgba f_color,
                                           bool  f_shouldUpdate_b = true );

        virtual bool            useAlpha() const { return m_useAlpha_b; }
        
        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        SRgba             m_color;

        /// Alpha channel?
        bool              m_useAlpha_b;
    };
}


#endif // __COLORPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: colorParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
