#ifndef __CAMERA_H
#define __CAMERA_H

/*@@@**************************************************************************
 ** \file  camera
 * \date   Wed Jun 10 18:33:01 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "paramIOHandling.h"
#include "ioObj.h"
#include "3DRowVector.h"

/* CONSTANTS */


namespace VIC
{
    
    class CCamera: public CIOObj
    {
    /// Constructors/Destructor
    public:
        
        CCamera ( );
        CCamera ( const CParamIOHandling & fr_paraReader );
        virtual ~CCamera();
        
    /// Get/Set methods.
    public:
        virtual bool load ( const CParamIOHandling & fr_paraReader );
        
    /// Get/Set methods.
    public:
        /// Focal length U.
        virtual void    setFu( double f_fu_d );
        virtual double  getFu() const;

        /// Focal length V.
        virtual void    setFv(double f_fv_d);
        virtual double  getFv() const;

        /// Principal Point U
        virtual void    setU0( double f_u0_d );
        virtual double  getU0() const;

        /// Principal Point V
        virtual void    setV0( double f_v0_d );
        virtual double  getV0() const;

        /// Principal Point
        virtual void   setPrincipalPoint( double f_v0_d, 
                                          double f_u0_d );
        
    /// Image/World transformations.
    public:
        /// World 3D point to image point.
        virtual bool   world2Image ( double  f_x_d, 
                                     double  f_y_d,
                                     double  f_z_d,
                                     double &fr_u_d,
                                     double &fr_v_d ) const;

        /// World 3D point to image point.
        virtual bool   world2Image ( C3DVector  f_point,
                                     double    &fr_u_d,
                                     double    &fr_v_d ) const;

        /// Image position to world position.
        virtual bool   imageAndDistance2World ( double  f_u_d, 
                                                double  f_v_d,
                                                double  f_z_d,
                                                double &fr_x_d,
                                                double &fr_y_d ) const;

    /// Operations on the camera
    public:       
        virtual void   scale ( double f_scale_d );
        

   /// Protected members:
    protected:

        /// Focal length.
        double             m_focalLength_d;

        /// Focal length in U.
        double             m_fu_d;

        /// Focal length in V
        double             m_fv_d;

        /// Principal point U component.
        double             m_u0_d;

        /// Principal point V component.
        double             m_v0_d;
    };
}
    
#endif // __CAMERA_H

/* ////////////  Version History ///////////////
 *  $Log: camera.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
