#ifndef __INT8IMAGE_H
#define __INT8IMAGE_H

/*@@@**************************************************************************
 ** \file  floatImage
 * \date   Wed Aug  5 15:32:02 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
*****          (C) COPYRIGHT Hernan Badino - All Rights Reserved          *****
******************************************************************************/

/* INCLUDES */
#include "typedImage.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<int8_t>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(int8_t) );
        setDataType( IDT_BYTE );
        setImageFormat( CImageBase::IF_LUMINANCE );
    }

    typedef CTypedImage<int8_t> CByteImage;
}



#endif // __INT8IMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: byteImage.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
