#ifndef __BOOLPARAM_H
#define __BOOLPARAM_H

/*@@@**************************************************************************
 ** \file  boolParam
 * \date   Mon Apr 27 13:51:09 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
******************************************************************************/

/* INCLUDES */
#include "parameter.h"

namespace VIC
{
    /* PROTOTYPES */

    class CBoolParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        CBoolParameter (  std::string               f_name_str = "",
                          std::string               f_comment_str = "",
                          bool                      f_value_b = false,
                          CParameterBaseConnector * f_connector_p = NULL );

        virtual ~CBoolParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set bool value
        virtual bool            getValue ( ) const;
        virtual bool            setValue ( bool f_value_b,
                                           bool f_shouldUpdate_b = true );


        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        bool                  m_val_b;
    };
}


#endif // __BOOLPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: boolParam.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
