#ifndef __3DVECTORPARAMEDITOR_H
#define __3DVECTORPARAMEDITOR_H

/**
 * @file dblt2DParamEditor.h
 *
 * \class C3DVectorParameterEditor
 * \date  Tue Oct 13, 2009
 * \author Hernan Badino (hernan.badino@gmail.com)
 *
 * \brief Implements an editor for an object of type C3DVectorParameter.
 *
 * The class implements a simple Qt editor with two input boxes where
 * the user enters double values.
 */

/* INCLUDES */
#include "baseParamEditorWidget.h"

#include "3DVectorParam.h"

/* PROTOTYPES */

namespace VIC
{
    /* PROTOTYPES */
    class CDoubleEditor;

    class C3DVectorParamEditor : public CBaseParamEditorWidget
    {
        Q_OBJECT
        public:
        
        /// Constructors/Destructor
        C3DVectorParamEditor ( C3DVectorParameter *  f_parameter_p,
                                QWidget *          f_parent_p = NULL );

        virtual ~C3DVectorParamEditor ();

        virtual bool updateWidget();
                             
    public slots:
        void updateParameter();

        /// Protected members
    protected:

        /// Stored value.
        CDoubleEditor *           m_qdsb_p[3];

        /// Associated Dbl2D parameter
        C3DVectorParameter *         m_parameter_p;

        /// Amount of decimals to consider.
        const static unsigned int m_maxDecimals_cui;
    };
}

#endif // __3DVECTORPARAMEDITOR_H

/* ////////////  Version History ///////////////
 *  $Log: 3DVectorParamEditor.h,v $
 *  Revision 1.1  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *//////////////////////////////////////////////
