#ifndef __3DVECTORPARAM_H
#define __3DVECTORPARAM_H

/*@@@**************************************************************************
 ** \file  3DVectorParam.h
 * \date   Mon Apr 27 13:51:09 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
*****     (C) COPYRIGHT Hernan Badino - All Rights Reserved               *****
******************************************************************************/

/* INCLUDES */
#include "parameter.h"
#include "3DRowVector.h"

namespace VIC
{
    /* PROTOTYPES */

    class C3DVectorParameter : public CParameter
    {
    public:
        
        /// Constructors/Destructor
        C3DVectorParameter (  std::string               f_name_str = "",
                              std::string               f_comment_str = "",
                              C3DVector                 f_val = C3DVector(0.,0.,0.),
                              std::string               f_name1_str = "x",
                              std::string               f_name2_str = "y",
                              std::string               f_name3_str = "z",
                              CParameterBaseConnector * f_connector_p = NULL );

        virtual ~C3DVectorParameter ();

    public:
        /// Get and set values from strings.
        virtual std::string     getStringFromValue ( ) const;
        virtual bool            setValueFromString ( std::string f_val_str );
 
        /// Get and set Dbl2D value
        virtual C3DVector       getValue ( ) const;
        virtual bool            setValue ( C3DVector   f_value,
                                           bool        f_shouldUpdate_b = true );
        
        const std::string *     getNames ( ) const 
        {
            return m_names_p;
        }

        /// Get editor.
        virtual QWidget *       createEditor ( );

    /// Protected members
    protected:

        /// Stored value.
        C3DVector    m_value;

        /// Stored value.
        std::string  m_names_p[3];
    };
}


#endif // __3DVECTORPARAM_H

/* ////////////  Version History ///////////////
 *  $Log: 3DVectorParam.h,v $
 *  Revision 1.1  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *//////////////////////////////////////////////
