#ifndef __3DVECTORIMAGE_H
#define __3DVECTORIMAGE_H

/*@@@**************************************************************************
 ** \file  3DVectorImage
 * \date   Mon Aug 10 10:11:07 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
*****          (C) COPYRIGHT Hernan Badino - All Rights Reserved          *****
******************************************************************************/

/* INCLUDES */
#include "typedImage.h"
#include "3DRowVector.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<C3DVector>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(C3DVector) );
        setDataType( IDT_DOUBLE );
        setImageFormat( CImageBase::IF_RGB );
    }

    typedef CTypedImage<C3DVector> C3DVectorImage;
}

#endif // __3DVECTORIMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: 3DVectorImage.h,v $
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
