/*@@@**************************************************************************
* \file  3DMatrix_inline.h
* \author Hernan Badino
* \date  Thu Jun 18 09:52:19 EDT 2009
* \notes 
*******************************************************************************
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include <string.h> /// For memcpy

//#include "3DMatrix.h"

inline void
C3DRowVector::clear ()
{
    memset(m_elems_p, 0, 3 * sizeof(double));

        //for (int i = 0; i < 3; ++i)
        //m_elems_p[i] = 0.;
}

inline void
C3DRowVector::print () const
{
    printf("\n%.15f %.15f %.15f\n", 
           m_x_d, m_y_d, m_z_d );
}

/// Sum with another vector.
inline C3DRowVector  
C3DRowVector::operator + ( const C3DRowVector & f_other ) const
{
    C3DRowVector result;

    result.m_x_d = m_x_d + f_other.m_x_d;
    result.m_y_d = m_y_d + f_other.m_y_d;
    result.m_z_d = m_z_d + f_other.m_z_d;

    return result;    
}


/// Subtraction with another vector.
inline C3DRowVector
C3DRowVector::operator - ( const C3DRowVector & f_other ) const
{
    C3DRowVector result;

    result.m_x_d = m_x_d - f_other.m_x_d;
    result.m_y_d = m_y_d - f_other.m_y_d;
    result.m_z_d = m_z_d - f_other.m_z_d;

    return result;
}


/// Unary sum.
inline C3DRowVector &
C3DRowVector::operator += ( const C3DRowVector & f_other )
{
    m_x_d += f_other.m_x_d;
    m_y_d += f_other.m_y_d;
    m_z_d += f_other.m_z_d;

    return *this;
}


/// Unary subtraction.
inline C3DRowVector &
C3DRowVector::operator -= ( const C3DRowVector & f_other )
{
    m_x_d -= f_other.m_x_d;
    m_y_d -= f_other.m_y_d;
    m_z_d -= f_other.m_z_d;

    return *this;
}

/// Get the magnitude of vector.
inline double
C3DRowVector::magnitude() const
{
    return sqrt(sumOfSquares());
}

/// Get the magnitude of vector.
inline double
C3DRowVector::sumOfSquares() const
{
    return m_x_d * m_x_d + m_y_d * m_y_d + m_z_d * m_z_d;
}


/// Get the magnitude of vector.
inline void
C3DRowVector::normalize()
{
    double mag_d = magnitude();
    
    m_x_d /= mag_d;
    m_y_d /= mag_d;
    m_z_d /= mag_d;
}

/// Return the cross product of two vectors.
inline C3DRowVector 
C3DRowVector::crossProduct ( const C3DRowVector & f_other ) const
{
    C3DRowVector res;

    res.m_x_d = m_y_d * f_other.m_z_d - m_z_d * f_other.m_y_d;
    res.m_y_d = m_z_d * f_other.m_x_d - m_x_d * f_other.m_z_d;
    res.m_z_d = m_x_d * f_other.m_y_d - m_y_d * f_other.m_x_d;

    return res;
}

/// Return the cross product of two vectors.
inline double
C3DRowVector::dotProduct ( const C3DRowVector & f_other ) const
{
    double val_d =  ( m_x_d * f_other.m_x_d +
                      m_y_d * f_other.m_y_d +
                      m_z_d * f_other.m_z_d );
    
    return val_d;
}

/// Return the cross product of two vectors.
inline double 
C3DRowVector::operator * ( const C3DRowVector & f_other ) const
{
    double val_d =  ( m_x_d * f_other.m_x_d +
                      m_y_d * f_other.m_y_d +
                      m_z_d * f_other.m_z_d );
    
    return val_d;
}

/// Comparison operator.
inline bool
C3DRowVector::operator == ( const C3DRowVector & f_other ) const
{
    return ( m_x_d == f_other.m_x_d && 
             m_y_d == f_other.m_y_d && 
             m_z_d == f_other.m_z_d );
}


/// Comparison operator.
inline bool
C3DRowVector::operator != ( const C3DRowVector & f_other ) const
{
    return ( m_x_d != f_other.m_x_d ||
             m_y_d != f_other.m_y_d || 
             m_z_d != f_other.m_z_d );
}



inline
C3DRowVector::operator bool (  ) const
{
    return ( m_x_d || m_y_d || m_z_d );
}

inline bool 
operator ! ( const C3DRowVector & f_vector )
{
    return (!f_vector.x() && !f_vector.y() && !f_vector.z());
}

inline C3DRowVector 
operator - ( const C3DRowVector & f_vector )
{
    return C3DRowVector(-f_vector.x(), -f_vector.y(), -f_vector.z() );
}


/* ////////////  Version History ///////////////
 *  $Log: 3DRowVector_inline.h,v $
 *  Revision 1.3  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *  Revision 1.2  2009/11/18 15:51:01  badino
 *  badino: documentation added. Some other global changes.
 *
 *//////////////////////////////////////////////
