#ifndef __3DMATRIXIMAGE_H
#define __3DMATRIXIMAGE_H

/*@@@**************************************************************************
 ** \file  3DMatrixImage
 * \date   Mon Aug 10 10:11:07 EDT 2009
 * \author Hernan Badino
 * \notes  
*******************************************************************************
*****          (C) COPYRIGHT Hernan Badino - All Rights Reserved          *****
******************************************************************************/

/* INCLUDES */
#include "typedImage.h"
#include "3DMatrix.h"

/* CONSTANTS */

namespace VIC
{
    /// Set Data.
    template <>
    inline void
    CTypedImage<C3DMatrix>::initializeTypedImage()
    {
        setBytesPerPixel( sizeof(C3DMatrix) );
        setDataType( IDT_DOUBLE );
        setImageFormat( CImageBase::IF_OTHER );
    }

    typedef CTypedImage<C3DMatrix> C3DMatrixImage;
}

#endif // __3DMATRIXIMAGE_H

/* ////////////  Version History ///////////////
 *  $Log: 3DMatrixImage.h,v $
 *  Revision 1.1  2010/01/18 17:12:29  badino
 *  General updates and added new classes.
 *
 *//////////////////////////////////////////////
