var scoreElem;      // score element for web page
var score = 0;
var fruit;

// FRUIT OBJECT
function makeFruit() {
    var fruit = { x: 0, y: 0, draw: drawFruit, move: moveFruit };
    return fruit;
}

function drawFruit() {
    stroke(255, 0, 0);
    point(this.x, this.y);
}

function moveFruit() {
    /*
    Set the fruit point to lie in between 100 and width-100, 
    and be rounded off to the nearest number divisible by 10, 
    since the snake moves in multiples of 10.
    */    
    this.x = floor(random(10, (width - 100) / 10)) * 10;
    this.y = floor(random(10, (height - 100) / 10)) * 10;
}

// Snake variables
var xTail = 0;
var yTail = 250;
var numSegments = 10;
var direction = 'right';
var xCor = [];
var yCor = [];

function initSnake() {
    for (var i = 0; i < numSegments; i++) {
        xCor.push(xTail + i * 10);
        yCor.push(yTail);
    }
}

function drawSnake() {
    stroke(255, 255, 255);
    for (var i = 0; i < numSegments - 1; i++) {
        line(xCor[i], yCor[i], xCor[i + 1], yCor[i + 1]);
    }
}

function moveSnake() {
    var x_diff = 0;
    var y_diff = 0;
    for (var i = 0; i < numSegments - 1; i++) {
        xCor[i] = xCor[i + 1];
        yCor[i] = yCor[i + 1];
    }
    switch (direction) {
        case 'right':
            x_diff = 10;
            break;
        case 'left':
            x_diff = -10;
            break;
        case 'down':
            y_diff = 10;
            break;
        case 'up':
            y_diff = -10;
            break;
    }
    xCor[numSegments - 1] = xCor[numSegments - 2] + x_diff;
    yCor[numSegments - 1] = yCor[numSegments - 2] + y_diff;
}


function snakeCollision() {
    /*
    If the snake hits itself, that means the snake head's (x,y) coordinate
    has to be the same as one of its own segment's (x,y) coordinate.
    */
    var snakeHeadX = xCor[numSegments - 1];
    var snakeHeadY = yCor[numSegments - 1];
    for (var i = 0; i < numSegments - 1; i++) {
        if (xCor[i] == snakeHeadX && yCor[i] == snakeHeadY) {
            return true;
        }
    }
    return false;
}


function setup() {
  scoreElem = createDiv('Score = 0');
  scoreElem.position(20, 20);
  scoreElem.id = 'score';
  scoreElem.style('color', 'white');

  createCanvas(500, 500);
  frameRate(15);
  strokeWeight(10);

  initSnake();
  fruit = makeFruit();
  fruit.move();
}

function draw() {
  background(0);
  fruit.draw();
  drawSnake();
  moveSnake();
  checkForCollision();      // with wall or itself
  checkForFruit();
}

function checkForCollision() {
    var xHead = xCor[numSegments - 1];
    var yHead = yCor[numSegments - 1];
    if (xHead > width || xHead < 0 || yHead > height || yHead < 0 ||
            snakeCollision() ) {
        noLoop();
        scoreElem.html('Game ended! Your score was : ' + score);
    }
}


/*
 Whenever the snake consumes a fruit, I increment the number of segments,
 and just insert the tail segment again at the start of the array (basically
 I add the last segment again at the tail, thereby extending the tail)
*/
function checkForFruit() {
    var xHead = xCor[numSegments - 1];
    var yHead = yCor[numSegments - 1];
    if (xHead == fruit.x && yHead == fruit.y) {
        score++;
        scoreElem.html('Score = ' + score);
        xCor.unshift(xCor[0]);
        yCor.unshift(yCor[0]);
        numSegments += 1;
        fruit.move();
    }
}

function keyPressed() {
    switch (keyCode) {
        case LEFT_ARROW:
        if (direction !== 'right') {
            direction = 'left';
        }
        break;

        case RIGHT_ARROW:
        if (direction !== 'left') {
            direction = 'right';
        }
        break;

        case UP_ARROW:
        if (direction !== 'down') {
            direction = 'up';
        }
        break;

        case DOWN_ARROW:
        if (direction !== 'up') {
            direction = 'down';
        }
        break;
    }
}
