var myCanvas; 

function setup() {
    myCanvas = createCanvas(200, 100);
    myCanvas.parent('aPlaceForCanvas');
}

function draw() {
    background(255);
    drawEye(0);         // Draw (left) eye, x offset = 0
    drawEye(100);       // Draw (right) eye, x offset = 100
}

function drawEye(ex) {
    fill(255);
    var x = 45 + ex;    // eye center x
    var y = 50;         // eye center y
    ellipse(x, y, 80, 60);
    var dx = mouseX - x; // dx, dy goes from eye to mouse
    var dy = mouseY - y;
    var d = dist(x, y, mouseX, mouseY); // distance to mouse
    d = max(30, d);     // avoid divide by zero
    dx = dx / d;        // now dx, dy goes from 0 to 1 in direction of mouse
    dy = dy / d;
    dx = dx * 25;       // scale dx, dy roughly to size of eye
    dy = dy * 15;
    fill(0);            // draw the pupil
    ellipse(x + dx, y + dy, 30, 30);
}