var films = [];
var data;

function preload() {
    data = loadJSON("films.json");
}

function setup() {
    createCanvas(480, 120);
    for (obj in data) {
        films.push(data[obj]);
    }
}

function draw() {
    background(0);
    for (var i = 0; i < films.length; i++) {
        var x = i*32 + 32;
        display(films[i], x, 105);
    }
    noLoop();
}

function display(film, x, y) {
    var ratingGray = map(film.rating, 6.5, 8.1, 102, 255);
    push();
    translate(x, y);
    rotate(-QUARTER_PI);
    fill(ratingGray);
    text(film.title, 0, 0);
    pop();
}