var cities;
var numRows;

function preload() {
    cities = loadTable("cities.csv", "header");
}

function setup() {
    createCanvas(480, 240);
    fill(255, 255, 0);  // yellow for cities
    noStroke();
    numRows = cities.getRowCount();
}

function draw() {
    background(0);
    // use mouse to zoom in and scroll across U.S.
    // comment these three lines out to see where U.S.
    // appears on the global map (full canvas)
    var xoffset = map(mouseX, 0, width, -width*3, -width);
    translate(xoffset, -375);
    scale(7);
    // display cities as points of "light"
    for (var i = 0; i < numRows; i++) {
        var latitude = cities.getNum(i, "lat");
        var longitude = cities.getNum(i, "lng");
        setXY(latitude, longitude);
    }
}

function setXY(lat, lng) {
    var x = map(lng, -180, 180, 0, width);
    var y = map(lat, 90, -90, 0, height);
    ellipse(x, y, 0.25, 0.25);
}
