var stats;
var numRows;

function preload() {
    stats = loadTable("ortiz.csv");
}

function setup() {
    createCanvas(480, 120);
    numRows = stats.getRowCount();
}

function draw() {
    background(200);
    drawGrid();
    drawGraph();
    noLoop();
}

function drawGrid() {
    print("drawGrid");
    stroke(150);
    line(20, 100, 20, 20);
    line(20, 100, 460, 100);
    for (var i = 0; i < numRows; i++) {
        var x = map(i, 0, numRows-1, 20, 460);
        line(x, 20, x, 100);
    }
}

function drawGraph() {
    print("drawGraph");
    noFill(); 
    stroke(255, 0, 0);
    beginShape();
    for (var i = 0; i < numRows; i++) {
        var x = map(i, 0, numRows-1, 20, 460);
        // column 1 (below) represents home runs
        // range of home runs is between 0 and 60
        var y = map(stats.getNum(i, 1), 0, 60, 100, 20);
        vertex(x,y);
    }
    endShape();
}
