function setup() {
    createCanvas(400, 400);
    frameRate(10);
}

function draw() {
    background(240);
    fill(0);
    recPattern(80, 80, 243);
}

function recPattern(x, y, size)
{
    // base case:
    if (size <= 3) {
        rect(x, y, size, size);
    } else { // recursive case:
        // draw smaller pattern in corners and center
        var third = size / 3;
        recPattern(x, y + third, third);             // left
        recPattern(x + 2 * third, y + third, third); // right
        recPattern(x + third, y, third);             // top
        recPattern(x + third, y + 2 * third, third); // bottom
    }
}
