function setup() {
    createCanvas(400, 400);
    frameRate(10);
}

function draw() {
    background(240);
    fill(0);
    recPattern(80, 80, 243);
}

function recPattern(x, y, size)
{
    // base case:
    if (size <= 3) {
        rect(x, y, size, size);
    } else { // recursive case:
        // draw smaller pattern in corners and center
        var third = size / 3;
        recPattern(x, y, third); // upper left
        recPattern(x + 2 * third, y, third); // upper right
        recPattern(x + third, y + third, third); // middle
        recPattern(x, y + 2 * third, third); // lower left
        recPattern(x + 2 * third, y + 2 * third, third); // lower right
    }
}
