// Game example
// A platform game, horizontal scrolling

// first, let's make a generative "landscape" with platforms
// each platform will be an object with an x, y, and w parameter

var platforms = [];
var marioY = 0;     // start mario character at top

// to scroll, we will increment offset. Everything is shifted left by offset
var offset = 0;

/////// PLATFORM OBJECT CODE /////

function newPlatform(px, py, pw) {
    var p = {x: px, y: py, w: pw,
             right: platRight};
    return p;
}

// compute the location of the right end of a platform
function platRight() {
    return this.x + this.w;
}

///////////////////////////////////


function setup() {
    createCanvas(600, 300);
    var pl = newPlatform(600, 200, 200);  // first platform
    platforms.push(pl);
}

function draw() {
    background("lightblue");
    fill("green");
    stroke("green");
    rect(0, height - 50, width, 50); // the ground
    
    fill(0);
    stroke(0);
    for (var i = 0; i < platforms.length; i++) {
        var p = platforms[i];
        rect(p.x - offset, p.y, p.w, 10);
    }

    // if first platform is offscreen to left, remove it
    if (platforms.length > 0 && platforms[0].right() < offset) {
        platforms.shift();
    }

    // if last platform is totally within canvas, make a new one
    var lastPlat = platforms[platforms.length-1];
    if (lastPlat.right() - offset < width) {
        var p = newPlatform(lastPlat.right(), // start location
              random(50, 225), // height of new platform
              200); // all platforms have width 200 for now
        platforms.push(p); // add to our array of platforms
    }

    // NEW CODE
    // move and draw the character "mario"
    // use linear search to find platform in the middle of canvas
    var pindex = 0;
    var marioX = width / 2;
    while (platforms[pindex].right() - offset < marioX) {
        pindex += 1;
    }
    // now pindex is index of the platform in the middle of canvas
    // find the platform height
    var py = platforms[pindex].y;
    // show some debugging information for now
    text("pindex " + pindex + " py " + py, 10, 50);
    // if we are above it, fall toward it, but do not go past it
    if (marioY <= py) {
        marioY = min(py, marioY + 1);
    } else { // if we are below it, fall to ground
        marioY = min(height, marioY + 1);
    }
    // wrap around, "fall from sky" again if we "die"
    if (marioY >= height) {
        marioY = 0;
    }
    // draw the "mario"
    fill("brown");
    stroke("brown");
    rect(marioX, marioY - 20, 20, 20);


    //debugging:
    text(platforms.length.toString() + " platform(s)", 10, 30);

    // move the "landscape"
    offset += 1;
}

