// Game example
// A platform game, horizontal scrolling

// first, let's make a generative "landscape" with platforms
// each platform will be an object with an x, y, and w parameter

var platforms = [];

// to scroll, we will increment offset. Everything is shifted left by offset
var offset = 0;

/////// PLATFORM OBJECT CODE /////

function newPlatform(px, py, pw) {
    var p = {x: px, y: py, w: pw,
             right: platRight};
    return p;
}

// compute the location of the right end of a platform
function platRight() {
    return this.x + this.w;
}

///////////////////////////////////


function setup() {
    createCanvas(600, 300);
    var pl = newPlatform(600, 200, 200);  // first platform
    platforms.push(pl);
}

function draw() {
    background("lightblue");
    fill("green");
    stroke("green");
    rect(0, height - 50, width, 50); // the ground
    
    fill(0);
    stroke(0);
    for (var i = 0; i < platforms.length; i++) {
        var p = platforms[i];
        rect(p.x - offset, p.y, p.w, 10);
    }

    // if first platform is offscreen to left, remove it
    if (platforms.length > 0 && platforms[0].right() < offset) {
        platforms.shift();
    }

    // if last platform is totally within canvas, make a new one
    var lastPlat = platforms[platforms.length-1];
    if (lastPlat.right() - offset < width) {
        var p = newPlatform(lastPlat.right(), // start location
              random(50, 225), // height of new platform
              200); // all platforms have width 200 for now
        platforms.push(p); // add to our array of platforms
    }


    //debugging:
    text(platforms.length.toString() + " platform(s)", 10, 30);

    // move the "landscape"
    offset += 1;
}

