var note = 60;
var steps = [2, 2, 1, 2, 2, 2, 1];
var stepIndex = 0;
var osc;
var env;
var rev;
var attackTime = 0.01;
var decayTime = 0.2;
var sustainPrct = 0.2;
var releaseTime = 0.5;
var count = 0;

function setup() {
    createCanvas(200, 100);
    frameRate(4);
    useSound();
}

function soundSetup() { 
    osc = new p5.Oscillator();
    osc.setType('sawtooth');
    env = new p5.Envelope();
    env.setADSR(attackTime, decayTime, sustainPrct, releaseTime);
    osc.amp(env);
    osc.freq(midiToFreq(note));

    delay = new p5.Delay();
    delay.process(osc, 0.12, .7, 2300);

//    reverb = new p5.Reverb();
//    reverb.process(osc, 3, 2);

    osc.start();
}

function draw() {
    print(count);
    background(200);
    if (count == 0) {
        // start first note
        osc.freq(midiToFreq(note));
        env.play();
    }
    else if (count % 4 == 0) {
        if (stepIndex == steps.length) {
            osc.stop();
            noLoop();
        }
        note += steps[stepIndex];
        osc.freq(midiToFreq(note));
        env.play();
        stepIndex++;
    }   
    count++; 
}

