var osc, env, vib, filt, fenv;

function setup() {
    createCanvas(400, 400);
    useSound();
}


function soundSetup() {
    // osc is the main tone generator
    osc = new p5.Oscillator();
    osc.setType('sawtooth');
    osc.freq(220);

    // env controls the amplitude shape of osc
    env = new p5.Envelope();
    env.setADSR(0.01, 1.2, 0.3, 0.2);
    osc.amp(env); // envelope controls the oscillator amplitude (loudness)

    // low-frequency oscillator for vibrato
    vib = new p5.Oscillator();
    vib.setType('sine');
    vib.freq(6);
    vib.amp(5); // controls depth of vibrato
    vib.start();
    osc.freq(vib); // modulate the osc frequency with vibrato

    // a filter to change the timbre or spectral quality
    filt = new p5.LowPass(); // allows sound up to some frequency to pass through
    osc.disconnect(); // stop playing the oscillator directly
    osc.connect(filt); // pass the osc output through the filter

    // filter control envelope
    fenv = new p5.Envelope();
    fenv.setADSR(0.3, 1.2, 1000, 0.2);
    fenv.setRange(8000, 400);
    filt.freq(fenv);

    osc.start();
}

function draw() {
    background(200);
}

function mousePressed() {
    env.triggerAttack(); // note on - play attack to sustain
    fenv.triggerAttack();
}

function mouseReleased() {
    env.triggerRelease(); // play the release part - turn note off
    fenv.triggerRelease();
}