var note = 60;
var steps = [2, 2, 1, 2, 2, 2, 1];
var stepIndex = 0;
var osc, osc2, osc3;
var env;
var attackTime = 0.01;
var decayTime = 0.2;
var sustainPrct = 0.2;
var releaseTime = 0.5;
var count = 0;

function setup() {
    createCanvas(200, 100);
    frameRate(4);
    useSound();
}

function soundSetup() { 
    osc = new p5.Oscillator();
    osc.setType('sawtooth');
    osc2 = new p5.Oscillator();
    osc2.setType('sawtooth');
    osc3 = new p5.Oscillator();
    osc3.setType('sawtooth');
    env = new p5.Envelope();
    env.setADSR(attackTime, decayTime, sustainPrct, releaseTime);
    osc.amp(env);
    osc2.amp(env);
    osc3.amp(env);
    osc.start();
    osc2.start();
    osc3.start();  
}

function draw() {
    print(count);
    background(200);
    if (count == 0) {
        // start first note
        osc.freq(midiToFreq(note));
        osc2.freq(midiToFreq(note+4));
        osc3.freq(midiToFreq(note+7));
        env.play();
    }
    else if (count % 4 == 0) {
        if (stepIndex == steps.length) {
            osc.stop();
            osc2.stop();
            osc3.stop();
            noLoop();
        }
        note += steps[stepIndex];
        osc.freq(midiToFreq(note));
        osc2.freq(midiToFreq(note+4));
        osc3.freq(midiToFreq(note+7));
        env.play();
        stepIndex++;
    }   
    count++; 
}

