var myTone;
var vibrato;

function setup() {
    createCanvas(300, 300);
    useSound();
}

function soundSetup() { // setup for audio generation
    myTone = new p5.Oscillator();
    myTone.setType('sine');
    myTone.start();
    vibrato = new p5.Oscillator();
    vibrato.setType('sine');
    vibrato.disconnect();
    vibrato.start();
}

function draw() {
    background(200);
    fill(0);
    ellipse(mouseX, mouseY, 20, 20);
    vibrato.amp(constrain(100 * (mouseY / height), 0, 100));
    vibrato.freq(constrain(1 + 3 * (mouseX / width), 1, 4));
    myTone.amp(0.5);
    myTone.freq(vibrato);
    if (mouseX > 2*width) {
        myTone.stop();
        noLoop();
    }
}