var myTone;

function setup() {
    createCanvas(300, 300);
    useSound();
}

function soundSetup() { // setup for audio generation
    myTone = new p5.Oscillator();
    myTone.setType('sine');
    myTone.freq(800);
    myTone.start();
}

function draw() {
    background(200);
    fill(0);
    ellipse(mouseX, mouseY, 20, 20);
    // volume:
    myTone.amp(constrain(mouseX / width, 0, 1));
    // pitch:
    myTone.freq(constrain(200 + 1000 * (mouseY / height), 200, 1200));
    if (mouseX > 2*width) {
        myTone.stop();
        noLoop();
    }
}