var np = 100;      // how many particles

function particleStep() {
    this.age++;
    this.x += this.dx;
    this.y += this.dy;
    if (this.x > width) { // bounce off right wall
        this.x = width - (this.x - width);
        this.dx = -this.dx;
    } else if (this.x < 0) { // bounce off left wall
        this.x = -this.x;
        this.dx = -this.dx;       
    }
    if (this.y > height) { // bounce off bottom
        this.y = height - (this.y - height);
        this.dy = -this.dy;
    } else if (this.y < 0) { // bounce off top
        this.y = -this.y;
        this.dy = -this.dy;
    }
}


function particleDraw() {
    point(this.x, this.y);
}


// create a "Particle" object with position and velocity
function makeParticle(px, py, pdx, pdy) {
    p = {x: px, y: py,
         dx: pdx, dy: pdy,
         age: 0,
         stepFunction: particleStep,
         drawFunction: particleDraw
        }
    return p;
}

var particles = [];


function setup() {
    createCanvas(400, 400);
    for (var i = 0; i < np; i++) {
        // make a particle
        var p = makeParticle(200, 200,
                             random(-50, 50), random(-50, 50));
        // push the particle onto particles array
        particles.push(p);
    }
    frameRate(10);
}


function draw() {
    background(230);
    stroke(0);
    strokeWeight(10);
    for (var i = 0; i < np; i++) { // for each particle
        var p = particles[i];
        // for each particle p, update its position (step)
        // and then draw it
        p.stepFunction();
        p.drawFunction();
    }
}

